# 5E01

a fantasy sound chip created by Euly, based on [the Ricoh 2A03 in the NES](nes.md), with some improvements:

- a 37.5% duty cycle,
- 32 noise pitches instead of 16, and
- triangle channel becomes a wave channel, with four available waveforms: triangle, saw, sine and square.

## effects

- `11xx`: **write to delta modulation counter.** range is `00` to `7F`.
  - this may be used to attenuate the triangle and noise channels; at `7F`, they will be at about 57% volume.
  - will not work if a sample is playing.
- `12xx`: **set duty cycle/noise mode/waveform of channel.**
  - may be `0` to `3` for the pulse channels:
    - `0`: 12.5%
    - `1`: 25%
    - `2`: 37.5%
    - `3`: 50%
  - may be `0` or `1` for the noise channel:
    - `0`: long (15-bit LFSR, 32767-step)
    - `1`: short (9-bit LFSR, 93-step)
  - may be `0` to `3` for the wave channel:
    - `0`: triangle
    - `1`: saw
    - `2`: square
    - `3`: sine
- `13xy`: **setup sweep up.**
  - `x` is the time.
  - `y` is the shift.
  - set to `0` to disable it.
- `14xy`: **setup sweep down.**
  - `x` is the time.
  - `y` is the shift.
  - set to `0` to disable it.
- `15xx`: **set envelope mode.**
  - `0`: envelope + length counter. volume represents envelope duration.
  - `1`: length counter. volume represents output volume.
  - `2`: looping envelope. volume represents envelope duration.
  - `3`: constant volume. default value. volume represents output volume.
  - pulse and noise channels only.
  - you may need to apply a phase reset (using the macro) to make the envelope effective.
- `16xx`: **set length counter.**
  - see [NES](nes.md) for more information.
  - this will trigger phase reset.
- `17xx`: **set frame counter mode.**
  - `0`: 4-step.
  - `1`: 5-step.
- `18xx`: **set PCM channel mode.**
  - `00`: PCM (software).
  - `01`: DPCM (hardware).
  - when in DPCM mode, samples will sound muffled (due to its nature), availables pitches are limited, and loop point is ignored.
- `19xx`: **set triangle linear counter.**
  - `00` to `7F` set the counter.
  - `80` and higher halt it.
- `20xx`: **set DPCM frequency.**
  - only works in DPCM mode.

## info

this chip uses the [NES](../4-instrument/nes.md) instrument editor.

## chip config

the following options are available in the Chip Manager window:

- **Clock rate**: sets the rate at which the chip will run.
- **DPCM channel mode**: allows you to set which mode to use for the DPCM channel.
  - DPCM: the default mode, playing 1-bit DPCM samples as supported by the hardware.
  - PCM: this mode provides crispier samples by writing the delta counter directly. uses a lot of CPU time in console.
